/* CANVAS */
var c = document.querySelector(".canvas");
c.width = window.innerWidth;
c.height = window.innerHeight;

var min = -500;
var max = 500;

var canvas = d3.select("canvas").node(),
    context = canvas.getContext("2d"),
    width = canvas.width,
    height = canvas.height;

/* PARTICULES */

var sites;
var nbParticule =100;
var TabVitesse = [];
for(var i=0; i<nbParticule; i++) TabVitesse[i]=[];


sites = d3.range(nbParticule)
    .map(function(d) { return [Math.round(Math.random() * width), Math.round(Math.random() * height)]; });

console.log(sites);

site();

console.log(sites);

function site(){

    var i;
    for (i = 0; i < nbParticule; i++) {
        TabVitesse[i][0] = Math.round(Math.random() * 2);
        TabVitesse[i][1] = Math.round(Math.random() * 2);
    }


    var i;
    for(i = 0; i < sites.length; i++) {

        if(sites[i][0] > 0 || sites[i][0] > window.innerWidth) {
            TabVitesse[i][0] *= -1;
        }

        if(sites[i][1] > 0 || sites[i][1] > window.innerHeight) {
            TabVitesse[i][1] *= -1;
        }

        sites[i][0] += TabVitesse[i][0];
        sites[i][1] += TabVitesse[i][1];
    }
}


function draw() {
    requestAnimationFrame(draw);

    context.beginPath();
    context.clearRect(0, 0, width, height);
    for (var i = 1, n = sites.length; i < n; ++i) drawSite(sites[i]);
    context.fillStyle = "red";
    context.fill();

    site();
}
draw();

function drawSite(site) {
    context.moveTo(site[0] + 2.5, site[1]);
    context.arc(site[0], site[1], 2.5, 0, 2 * Math.PI, false);
}




/*
sites = d3.range(nbParticule)
    .map(function(d) { return [Math.random() * width, Math.random() * height]; });

var voronoi = d3.voronoi()
    .extent([[-1, -1], [width + 1, height + 1]]);

redraw();
draw();

function redraw() {
    var diagram = voronoi(sites),
        links = diagram.links(),
        polygons = diagram.polygons();

    context.clearRect(0, 0, width, height);

    context.beginPath();
    var gradient = context.createLinearGradient(0, 0, window.innerWidth, 0);
    gradient.addColorStop("0", "#e72150");
    gradient.addColorStop("1", "#46bfee");
    for (var i = 0, n = polygons.length; i < n; ++i) drawCell(polygons[i]);
    context.lineWidth=2;
    context.strokeStyle = gradient;
    context.stroke();

    context.beginPath();
    for (var i = 0, n = links.length; i < n; ++i) drawLink(links[i]);
    context.strokeStyle = "rgba(0,0,0,0.2)";
    context.stroke();

    context.beginPath();
    context.fillStyle = "#000";
    context.fill();

    context.beginPath();
    for (var i = 1, n = sites.length; i < n; ++i) drawSite(sites[i]);
    context.fillStyle = "#s";
    context.fill();
    context.strokeStyle = "#000";
    context.stroke();
}

function drawSite(site) {
    context.moveTo(site[0] + 2.5, site[1]);
    context.arc(site[0], site[1], 2.5, 0, 2 * Math.PI, false);
}

function drawLink(link) {
    context.moveTo(link.source[0], link.source[1]);
    context.lineTo(link.target[0], link.target[1]);
}


function drawCell(cell) {
    if (!cell) return false;
    context.moveTo(cell[0][0], cell[0][1]);
    for (var j = 1, m = cell.length; j < m; ++j) {
        context.lineTo(cell[j][0], cell[j][1]);
    }
    context.closePath();
    return true;
}

function draw() {

    setTimeout(function() {
        requestAnimationFrame(draw);


        site();
        redraw();


    }, 1000 / 10);

}
*/